// NetReceiverDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetReceiver.h"
#include "NetReceiverDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CNetReceiverApp theApp;

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetReceiverDlg dialog


CNetReceiverDlg::CNetReceiverDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetReceiverDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetReceiverDlg)

	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}


// COMMUNICATION EMULATOR SCAN DONE CALLBACK
//
QRETURN on_emulator_scan_done_callback( PVOID pEmulator /*IN*/, ULONG nTotalServers /*IN*/, PVOID pUserData /*IN*/ )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

	pNetReceiverDlg->m_DeviceInfo.IP_Address = (char**)new char[ nTotalServers ];
	pNetReceiverDlg->m_DeviceInfo.Port = new unsigned long[ nTotalServers ];
	
	SC_DEBUG("--------nTotalServers = %d", nTotalServers);

	for(int i=0; i<nTotalServers; i++)
	{
		QCAP_GET_COMMUNICATION_EMULATOR_SERVER_INFO( pNetReceiverDlg->m_pEmulator, i, &pNetReceiverDlg->m_DeviceInfo.IP_Address[ i ], &pNetReceiverDlg->m_DeviceInfo.Port[ i ], &pNetReceiverDlg->ppszNetworkURL );
		
		pNetReceiverDlg->AddList(pNetReceiverDlg->ppszNetworkURL);

	}

	return QCAP_RT_OK;
}


void CNetReceiverDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetReceiverDlg)

	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_LIST_EMULATOR_DEVICE, m_device_list);
}

BEGIN_MESSAGE_MAP(CNetReceiverDlg, CDialog)
	//{{AFX_MSG_MAP(CNetReceiverDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()

	ON_WM_TIMER()

	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_START_EMULATOR, &CNetReceiverDlg::OnBnClickedButtonStartEmulator)
	ON_BN_CLICKED(IDC_BUTTON_STOP_EMULATOR, &CNetReceiverDlg::OnBnClickedButtonStopEmulator)
	ON_LBN_DBLCLK(IDC_LIST_EMULATOR_DEVICE, &CNetReceiverDlg::OnDblclkListEmulatorDevice)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetReceiverDlg message handlers

BOOL CNetReceiverDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	m_pEmulator = NULL;

	ppszNetworkURL = 0;

	UpdateData( FALSE );

	SetTimer( 0x00000000, 1000, NULL );

	GetDlgItem( IDC_BUTTON_START_EMULATOR )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP_EMULATOR )->EnableWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetReceiverDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// UNINITIALIZE USER INTERFACE
	//
	KillTimer( 0x00000000 );

	if ( m_pEmulator ) {

		QCAP_STOP_COMMUNICATION_EMULATOR( m_pEmulator );

		QCAP_DESTROY_COMMUNICATION_EMULATOR( m_pEmulator );

		m_pEmulator = NULL;
	}

	UpdateData( TRUE );
	


	// UNINITIALIZE COM LIBRARY
	//
	CoUninitialize();
}

void CNetReceiverDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetReceiverDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetReceiverDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CNetReceiverDlg::OnOK() 
{
	// TODO: Add extra validation here

//	CDialog::OnOK();
}

void CNetReceiverDlg::OnCancel() 
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}

void CNetReceiverDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	CDialog::OnTimer(nIDEvent);
}

void CNetReceiverDlg::AddList(char* item)
{
	if (item != NULL)
	{
		CString  strItem( item );
		m_device_list.AddString( strItem );
	}
}


void CNetReceiverDlg::OnBnClickedButtonStartEmulator()
{
	// TODO: Add your control notification handler code here

	QCAP_CREATE_COMMUNICATION_ONVIF_EMULATOR( &m_pEmulator );

	QCAP_REGISTER_COMMUNICATION_EMULATOR_SCAN_DONE_CALLBACK( m_pEmulator, on_emulator_scan_done_callback, this );

	QCAP_START_COMMUNICATION_EMULATOR( m_pEmulator );

	GetDlgItem( IDC_BUTTON_STOP_EMULATOR )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_START_EMULATOR )->EnableWindow( FALSE );
}


void CNetReceiverDlg::OnBnClickedButtonStopEmulator()
{
	// TODO: Add your control notification handler code here

	if ( m_pEmulator ) {

		QCAP_STOP_COMMUNICATION_EMULATOR( m_pEmulator );

		QCAP_DESTROY_COMMUNICATION_EMULATOR( m_pEmulator );

		m_pEmulator = NULL;
	}

	GetDlgItem( IDC_BUTTON_START_EMULATOR )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP_EMULATOR )->EnableWindow( FALSE );

}


void CNetReceiverDlg::OnDblclkListEmulatorDevice()
{
	// TODO: Add your control notification handler code here
}
